import Image from "next/image"

export function HowItWorks() {
  const steps = [
    {
      number: "01",
      title: "Create Your Profile",
      description: "Sign up and personalize your learning profile with your interests and goals.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/create-your-profile-use-younger-student-image-soWytf1DhaQtCo9JSV5SCxVXnvHzUP.png",
    },
    {
      number: "02",
      title: "Join or Create Labs",
      description: "Connect with existing study groups or create your own collaborative lab.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/join-or-create-labs-KYOgQGlFeFgYQ4bhvkSQ4gfjmin1W3.png",
    },
    {
      number: "03",
      title: "Share Ideas & Projects",
      description: "Post your ideas on the Idea Board and collaborate on projects with peers.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/share-ideas---projects-HPcJs1rPffGP9G3YIYEhMHqKd10jng.png",
    },
    {
      number: "04",
      title: "Learn & Grow Together",
      description: "Practice with quizzes, participate in live study sessions, and track your progress.",
      image:
        "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/learn---grow-together-LH3WFz4zv1gz9j9srzZjJu4hCvb8um.png",
    },
  ]

  return (
    <section className="py-20">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">How Dolabing Works</h2>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Follow these simple steps to get started with your collaborative learning journey.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {steps.map((step, index) => (
            <div key={index} className="relative">
              <div className="rounded-xl overflow-hidden mb-6 aspect-square relative">
                <Image src={step.image || "/placeholder.svg"} alt={step.title} fill className="object-cover" />
                <div className="absolute top-4 left-4 bg-teal-500 text-white text-xl font-bold w-12 h-12 rounded-full flex items-center justify-center">
                  {step.number}
                </div>
              </div>
              <h3 className="text-xl font-bold mb-2">{step.title}</h3>
              <p className="text-gray-600">{step.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
